# LIGO-Virgo GWTC-3 Tests of GR

## pSEOBNRv4HM ringdown analysis

Data release for the pSEOBNRv4HM ringdown analysis, Sec. VIII A.2 in Abbott et al (2021), _Tests of General Relativity with GWTC-3_.

### Contents
- Data
   1. `./cache/rin/pseob`: contains `*.txt.gz` files with the results of the pSEOB analysis of GWTC-3 events.
   2. `./cache/rin/pseobO3a`: contains `*.txt.gz` files with the results of the pSEOB analysis of GWTC-2 events. 
   3. `./combined_samples`: contains `*.dat.gz` files with the combined posteriors on the fractional deviations in the frequency and damping time of the least-damped dominant QNM.
   4. `./S*` folders: contain `*.dat.gz` files with the posteriors for the frequency and damping time of the least-damped dominant QNM and their fractional deviations. 
- Plotting utilities called by main script
   1. `dict_det_masses.json`
   2. `colors.pkl`
   3. `parameters.pkl`
   4. `parameters_o1o2.pkl`
   5. `utils.py`
- Main plotting script
   1. `plot_pseob_results_O3b.ipynb`: Jupyter notebook to reproduce the two panels of Fig. 14
- Tables and figures 
   1. `pseob_table_lvc_events.tex`: Tab. XIII of the paper. 
   2. `rin_all_events_bounds.pdf`: right panel of Fig. 14 of the paper. 
   3. `rin_pseob_results_v2.pdf`: left panel of Fig. 14 of the paper.


Please see comments within Jupyter notebook for further details.

### Environment

This code is designed to run under the `gwtc3-tgr` Conda environment shipped with this release. You can create this environment from the enclosed `environment.yml` file by doing
```
conda env create -f environment.yml
```
Note that this environment is the same for all tests in this paper, so you only need to install it once. You can activate it with
```
conda activate gwtc3-tgr
```
after that, you should be able to start `jupyter-lab` to open the Jupyter notebooks in this release.

For help installing Conda, see the [documentation](https://conda.io/projects/conda/en/latest/user-guide/install/index.html).

### Acknowledgement

If you make use of these data or software in your own work, please include the following acknowledgement:

"This research has made use of data, software and/or web tools obtained from the Gravitational Wave Open Science Center (https://www.gw-openscience.org/), a service of the LIGO Laboratory, the LIGO Scientific Collaboration and the Virgo Collaboration. LIGO is funded by the U.S. National Science Foundation. Virgo is funded, through the European Gravitational Observatory (EGO), by the French Centre National de Recherche Scientifique (CNRS), the Italian Istituto Nazionale della Fisica Nucleare (INFN) and the Dutch Nikhef, with contributions by institutions from Belgium, Germany, Greece, Hungary, Ireland, Japan, Monaco, Poland, Portugal, Spain."

### License

This work is licensed under the Creative Commons Attribution 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

