%%% Plot the parameters and ringdown of the new flexure from HPD in the
%%% GS-13. 
%%% DEC 2009.10.27

clc; clear all; close all;

%% Load the data
load('flexureringdown_01.mat');
T1 = flexureringdown_01.X.Data;
R1 = flexureringdown_01.Y(1).Data;
clear flexureringdown_01

load('flexureringdown_02.mat');
T2 = flexureringdown_02.X.Data;
R2 = flexureringdown_02.Y(1).Data;
clear flexureringdown_02

load('flexureringdown_03.mat');
T3 = flexureringdown_03.X.Data;
R3 = flexureringdown_03.Y(1).Data;
clear flexureringdown_03

load('flexureringdown_04.mat');
T4 = flexureringdown_04.X.Data;
R4 = flexureringdown_04.Y(1).Data;
clear flexureringdown_04

%% Plot the ringdowns
% figure(1)
% 
% subplot(221)
% plot(T1, R1, 'r-')
% xlabel('Time [s]')
% ylabel('Output [dV]')
% grid on
% title('\bf Ringdown Plots of the GS-13 with new flexures')
% 
% subplot(222)
% plot(T2, R2, 'g-')
% xlabel('Time [s]')
% ylabel('Output [dV]')
% grid on
% 
% subplot(223)
% plot(T3, R3, 'b-')
% xlabel('Time [s]')
% ylabel('Output [dV]')
% grid on
% 
% subplot(224)
% plot(T4, R4, 'c-')
% xlabel('Time [s]')
% ylabel('Output [dV]')
% grid on
% 
% IDfig
% FillPage('withWisdom')

%% Fit the curves

% Set start and stop time for the ringdown data
T_start_1 = 1;
T_stop_1  = max(T1(:)); %Use all data
Fit_Seg_1 = find(T1(:) > T_start_1 & T1(:) < T_stop_1);

T_start_2 = 2.65;
T_stop_2  = max(T2(:)); %Use all data
Fit_Seg_2 = find(T2(:) > T_start_2 & T2(:) < T_stop_2);

T_start_3 = 2.1;
T_stop_3  = max(T3(:)); %Use all data
Fit_Seg_3 = find(T3(:) > T_start_3 & T3(:) < T_stop_3);

T_start_4 = 1.4;
T_stop_4  = max(T4(:)); %Use all data
Fit_Seg_4 = find(T4(:) > T_start_4 & T4(:) < T_stop_4);

% Set initial parameters for fit
ringdown(1) = 0.2;  % Initial amplitude
ringdown(2) = 1;    % Initial frequency guess
ringdown(3) = 2;    % Sine phase
ringdown(4) = 50;   % Q
ringdown(5) = 1.5;

% Define a damped sinusoid. 
damped_sine = @(p,t)  p(1) * sin(2 * pi * p(2) * t + p(3)) .* exp(-(t * 2 * pi * p(2)) / (2 * p(4)) ) + p(5);

%Perform non-linear fit to the time domain data;
F1_ringdown = nlinfit(T1(Fit_Seg_1),R1(Fit_Seg_1),damped_sine,ringdown);
F2_ringdown = nlinfit(T2(Fit_Seg_2),R2(Fit_Seg_2),damped_sine,ringdown);
F3_ringdown = nlinfit(T3(Fit_Seg_3),R3(Fit_Seg_3),damped_sine,ringdown);
F4_ringdown = nlinfit(T4(Fit_Seg_4),R4(Fit_Seg_4),damped_sine,ringdown);

%% Plot the ringdowns and fits
figure(2)

subplot(221)
plot(T1, R1, 'k-', T1(Fit_Seg_1), damped_sine(F1_ringdown,T1(Fit_Seg_1)), 'r-');
xlabel('Time [s]')
ylabel('Output [dV]')
grid on
legend([num2str(F1_ringdown(2)) 'Hz ' num2str(F1_ringdown(4)) 'Q'])
title('\bf Ringdown Plots of the GS-13 With New Flexures')

subplot(222)
plot(T2, R2, 'k-', T2(Fit_Seg_2), damped_sine(F2_ringdown,T2(Fit_Seg_2)), 'g-');
xlabel('Time [s]')
ylabel('Output [dV]')
grid on
legend([num2str(F2_ringdown(2)) 'Hz ' num2str(F2_ringdown(4)) 'Q'])

subplot(223)
plot(T3, R3, 'k-', T3(Fit_Seg_3), damped_sine(F3_ringdown,T3(Fit_Seg_3)), 'b-');
xlabel('Time [s]')
ylabel('Output [dV]')
grid on
legend([num2str(F3_ringdown(2)) 'Hz ' num2str(F3_ringdown(4)) 'Q'])

subplot(224)
plot(T4, R4, 'k-', T4(Fit_Seg_4), damped_sine(F4_ringdown,T4(Fit_Seg_4)), 'c-');
xlabel('Time [s]')
ylabel('Output [dV]')
grid on
legend([num2str(F4_ringdown(2)) 'Hz ' num2str(F4_ringdown(4)) 'Q'])

IDfig
FillPage('withWisdom')

%% Plot the figure
%{
figure(2)
print -dpdf RingDownFits_NewFlexures_GS-13
%}










