%%% Flexure Break Tests
% DEC 2009.10.06

%% Housekeeping
clc; clear all; close all;

%% Load the data
% Failure of one flexure when in series with the 4 total flexure elements
load('C:\experiments\repo\HAM-ISI\Stanford\GS13\FlexureBreak006.mat')

% Failure of the 0.004 flexure when it is just by itself
load('C:\experiments\repo\HAM-ISI\Stanford\GS13\FlexureBreak007.mat')

% Failure of one flexure when in series with the 4 total flexure elements
load('C:\experiments\repo\HAM-ISI\Stanford\GS13\FlexureBreak_B002.mat')

% Failure of the 0.004 flexure when it is just by itself (not constrained
% well with twisting
load('C:\experiments\repo\HAM-ISI\Stanford\GS13\flexurebreak_c003.mat')

%% Grab the Data

T1 = flexurebreak006.X.Data;
T2 = flexurebreak007.X.Data;
T3 = flexurebreak_b002.X.Data;
T4 = flexurebreak_c003.X.Data;

D1 = flexurebreak006.Y(1).Data;
D2 = flexurebreak007.Y(1).Data;
D3 = flexurebreak_b002.Y(1).Data;
D4 = flexurebreak_c003.Y(1).Data;

%% Calibrate the Data to LBF and Gs

DP1 = D1*20*10; % 20 pounds / volt 10 volts / dspace unit
DP2 = D2*20*10; 
DP3 = D3*20*10; 
DP4 = D4*20*10; 

DG1 = DP1*0.2722;
DG2 = DP2*0.2722;
DG3 = DP3*0.2722;
DG4 = DP4*0.2722;

%% Plot the Graphs

figure(1)
subplot(211)
plot(T1, DP1, 'r-', T1, (73.487*ones(1,length(T1))), 'g--', 'LineWidth',2)
axis([0, 45, -2, 80])
ylabel('Loading [LBf]')
xlabel('Time [sec]')
title('\bf Loading of GS-13 Flexure A after Vibratory Finishing at Max. Offset to Failure')
grid on

subplot(212)
plot(T1, DG1, 'b-', T1, (20*ones(1,length(T1))), 'g--', 'LineWidth', 2)
axis([0, 45, -2, 25])
ylabel('Loading [G]')
xlabel('Time [sec]')
grid on
FillPage('world')
IDfig

figure(2)
subplot(211)
plot(T3, DP3, 'r-', T3, (73.487*ones(1,length(T3))), 'g--', 'LineWidth', 2)
axis([0, 135, -2, 80])
ylabel('Loading [LBf]')
xlabel('Time [sec]')
title('\bf Loading of GS-13 Flexure B after Vibratory Finishing at Max. Offset to Failure')
grid on

subplot(212)
plot(T3, DG3, 'b-', T3, (20*ones(1,length(T3))), 'g--', 'LineWidth', 2)
axis([0, 135, -2, 25])
ylabel('Loading [G]')
xlabel('Time [sec]')
grid on
FillPage('world')
IDfig

figure(3)
subplot(211)
plot(T2, DP2, 'r-', T2, (73.487*ones(1,length(T2))), 'g--', 'LineWidth', 2)
axis([0, 75, -2, 150])
ylabel('Loading [LBf]')
xlabel('Time [sec]')
title('\bf Loading of GS-13 Flexure Single Element Only, Inline after Vibratory Finishing to Failure')
grid on

subplot(212)
plot(T2, DG2, 'b-', T2, (20*ones(1,length(T2))), 'g--', 'LineWidth', 2)
axis([0, 75, -2, 40])
ylabel('Loading [G]')
xlabel('Time [sec]')
grid on
FillPage('world')
IDfig

figure(4)
subplot(211)
plot(T4, DP4, 'r-', T4, (73.487*ones(1,length(T4))), 'g--', 'LineWidth', 2)
axis([0, 30, -2, 80])
ylabel('Loading [LBf]')
xlabel('Time [sec]')
title('\bf Loading of GS-13 Flexure Single Element Only, Offset, Rotation Poorly Constrained after Vibratory Finishing to Failure')
grid on

subplot(212)
plot(T4, DG4, 'b-', T4, (20*ones(1,length(T4))), 'g--', 'LineWidth', 2)
axis([0, 30, -2, 22])
ylabel('Loading [G]')
xlabel('Time [sec]')
grid on
FillPage('world')
IDfig

%% Grab the Maximum Values for Each of the Runs
clc;
M.DP1 = max(DP1);
M.DP2 = max(DP2);
M.DP3 = max(DP3);
M.DP4 = max(DP4);
disp('Pounds Force')

M.DG1 = max(DG1);
M.DG2 = max(DG2);
M.DG3 = max(DG3);
M.DG4 = max(DG4)
disp('Max G Loading')

%% Print the figures
%{
figure(1)
print -dpdf GS13_LT_1

figure(2)
print -dpdf GS13_LT_2

figure(3)
print -dpdf GS13_LT_3

figure(4)
print -dpdf GS13_LT_4