%  Web_thickness.m 
%  Calculates minimum web thickness for the measured flexures
%  Webs are labaled as flexure #(L/S)(L/U) for (long/short) and
%  (lower/upper) 
%  The upper portion of the web is the top surface, when the long mount
%  flag is on the left.

% Graham Allen
% 8/18/2009

%% Load the main data file

%newData1 = importdata('flexures_all.xls');
clear all;
if ~exist('CMM_WEB_DATA_LOADED','var')
    [data, headers]=xlsread('flexures_all.xls');
    var_names=headers(2:end,1);
    field_names=headers(1,:);
    for j=1:(size(headers,1)-1)
        % Generate individual variables for each measured cylinder
        eval(['web_',headers{j+1,1},'=data(j,:);']);
    end
    clear data headers;
    CMM_WEB_DATA_LOADED=true;
end

%% Iterate over the flexure pairs.

%For each flexure
for j=1:3
    for side=['L','S']
        if exist(['web_',num2str(j),side,'U'],'var') && exist(['web_',num2str(j),side,'L'],'var')
            eval(['top=','web_',num2str(j),side,'U;'])
            eval(['bot=','web_',num2str(j),side,'L;'])
            % Calculate center to center distance
            c2c_dist=sqrt( sum((top(1:2)-bot(1:2)).^2));            
            %Subtract radius of each cylinder
            web_thick=c2c_dist-top(8)-bot(8);
            disp(['Thickness of web ',num2str(j),side,'= ',num2str(web_thick),' mm (',num2str(1e-5*round(1e5*web_thick/25.4)),' in)'])
        end
    end
end