%Flexure comparison

close all;
clear all;
INCH=0.0254; %Conversion to/from inch to meter

F1L=FlexureResonantResponse('Flexure1L.csv','bottom-long');
F1S=FlexureResonantResponse('Flexure1S.csv','bottom-short');
F2S=FlexureResonantResponse('Flexure2S.csv','bottom-short');
F3L=FlexureResonantResponse('Flexure3L.csv','custom',false,87,3.60206e-007);
F3S=FlexureResonantResponse('Flexure3S.csv','custom',false,106,2.7796e-007);

% Crude measurements using CMM
%long_thick=[0.00423, NaN, 0.00461]; %in
%short_thick=[0.00458, 0.00332, 0.00438]; %in

% Flexure gauge
long_thick=[0.00452, NaN, .00469];
short_thick=[0.00503, 0.00458, 0.00499];
long_freq=[F1L.freq, NaN, F3L.freq];
short_freq=[F1S.freq, F2S.freq, F3S.freq];
long_stiff=[F1L.stiffness, NaN, F3L.stiffness];
short_stiff=[F1S.stiffness, F2S.stiffness, F3S.stiffness];
long_calc_thick=[F1L.thick, NaN, F3L.thick]/INCH;
short_calc_thick=[F1S.thick, F2S.thick, F3S.thick]/INCH;

clf;
plot(long_freq,long_thick*1e3,'x', short_freq,short_thick*1e3,'d',...
    [70, 110],3.5*[1 1],'--r', [70,110],4.5*[1 1],'--r','MarkerSize',12);
legend('Long web','Short web')
text(71,3.55,'Minimum web thickness')
text(71,4.43,'Maximum web thickness')
xlabel('Resonant Frequency (Hz)')
ylabel('Web thickness (mils)');

figure;
plot(1e3*long_thick, long_stiff,'x', 1e3*short_thick,short_stiff,'d',...
    [3 5], 0.136*[1 1],'--r','MarkerSize',12);
text(3.042,0.139, 'Original GS-13 Flexure stiffness');
legend('Long web','Short web')
xlabel('Web thickness (mils)');
ylabel('Flexure stiffness (N \cdotm)');

figure;
plot(1e3*long_thick, 1e3*long_calc_thick, 'x', 1e3*short_thick,1e3*short_calc_thick,'d',...
    [3 5.5],[3, 5.5],'--r','MarkerSize',12);
axis([3 5.5 3 5.5])
legend('Long web', 'Short web');
%xlabel('CMM thickness (mils)');
xlabel('Flexure gauge measurement (mils)');
ylabel('Frequency inferred thickness (mils)');