% Monte-Carlo tab moment of inertia
function []=MC_tab_moment()
INCH=2.54; %cm
rho=8.15; %gm/cm^3

MC_iter=1e5;
TOL=0.005;  %Dimension std. dev. in inches

rand_fcn=@(N) 2*(rand(N)-0.5);

T=0.25*INCH;
Itot=zeros(1,MC_iter);
for k=1:MC_iter
    %Main block
    T=(0.25+TOL*rand_fcn(1))*INCH;
    W=(0.375+TOL*rand_fcn(1))*INCH;
    H=(0.438+TOL*rand_fcn(1))*INCH;
    x0=[0.125, 0.438]*INCH;
    I1=block_Ix(sqrt(x0*x0'), T, W, H, rho);
    
    %Main cut block
    dx=(0.1+TOL*rand_fcn(1))*INCH;
    dy=(0.25+TOL*rand_fcn(1))*INCH;
    x1=[.125, 0.438]*INCH;
    I2=block_Ix(sqrt(x1*x1'), dx, dy, H,-rho);
    
    %Thru hole
    r=(0.125+TOL*rand_fcn(1))*INCH;
    x2=([0.125, 0.438]+TOL*rand_fcn([1,2]))*INCH;
    I3=cyl_Iz(sqrt(x2*x2'),r,T-dx,-rho);
    
    Itot(k)=I1+I2+I3;
end
    
disp(['Nominal moment = ',num2str(mean(Itot)),' g.cm^2'])
disp(['Standard Dev. = ',num2str(std(Itot)),' g.cm^2'])
disp(['Relative uncertainty = ', num2str(std(Itot)/mean(Itot))]);
hist(Itot,40)
       
    
function Ixx = block_Ix(d,dx,dy,dz,density)
m=dx*dy*dz*density;
Ixx=1/12*m*(dy^2+dz^2)+m*d^2;

function Izz = cyl_Iz(d,r,h,density)
m=pi*h*r^2*density;
Izz=m*r^2+m*d^2;


function Ixx = cyl_Ix(d,r,h,density)
m=pi*h*r^2*density;
Ixx=1/12*m*(3*r^2+h^2)+m*d^2;