%% Initialization
close all;
clear all;
clc;
INCH=0.0254; %Conversion to/from inch to meter
cur_dir=pwd;
cd ..
path(path,pwd);
cd 'HPD_Flexures'

%% Bottom Flexures

dirc='./Bottom_D091318/';

SN_base='D091318-v3-';
SN_list=num2str((1:7)','%03i');

FL=struct;
file_base='TEK';
file_num=0;
for k=1:length(SN_list)
    SN=[SN_base,SN_list(k,:)];
    file_num=file_num+1;
    FL=struct;
    FL.type='bottom';
    FL.serial_num=SN;
    FL.short=FlexureResonantResponse([dirc,file_base,num2str(file_num,'%04i'),'.csv'],'bottom-short',FL.serial_num);
    file_num=file_num+1;
    FL.long=FlexureResonantResponse([dirc,file_base,num2str(file_num,'%04i'),'.csv'],'bottom-long',FL.serial_num);
    eval([strrep(SN,'-','_'),'=FL;']);
end

%% Top Flexures
dirc='./Top_D091319/';

SN_base='D091319-v3-';
SN_list=num2str((1:7)','%03i');

FL=struct;
file_base='TEK';
file_num=0;
for k=1:length(SN_list)
    SN=[SN_base,SN_list(k,:)];
    file_num=file_num+1;
    FL=struct;
    FL.type='top';
    FL.serial_num=SN;
    FL.short=FlexureResonantResponse([dirc,file_base,num2str(file_num,'%04i'),'.csv'],'top-short',FL.serial_num);
    file_num=file_num+1;
    FL.long=FlexureResonantResponse([dirc,file_base,num2str(file_num,'%04i'),'.csv'],'top-long',FL.serial_num);
    eval([strrep(SN,'-','_'),'=FL;']);
end

