addpath('../../../MATLAB')
clear all;
TipR=1.988/2;
INCH=25.4;
FLEX_H=0.25*INCH;
FLEXURE='Flexure1';

if ~exist('DATA_LOADED','var')
    eval(['load ',FLEXURE,'_raw']);
    DATA_LOADED=true;
end
clc;
%% Process cylinders
if ~exist('FITTED','var')
    for web={'Long','Short'}        
        for loc={'Top','Bottom'}
            if exist([FLEXURE,web{1},loc{1}],'var')
                disp(['Fitting cylinders for ', FLEXURE,web{1},loc{1}]);
                switch loc{1}
                    case 'Top'
                        guess=[0.25*INCH-TipR, 0,1,0, .25*INCH-TipR,0, 0, 1];

                    case 'Bottom'
                        guess=[0.25*INCH-TipR, 0,-1,0, .25*INCH-TipR,0, 0, 1];
                end
                fit_cyl.R=0;
                fit_cyl.exitflag=0;
                Niter=1;
                while (((abs(fit_cyl.R+TipR-0.25*INCH))>1) || (Niter<10 && fit_cyl.exitflag<=0))
                    eval(['fit_cyl=cylinder_fit(',FLEXURE,web{1},loc{1},'.data,guess);']);
                    disp(['Iteration #',num2str(Niter), ' Cylinder radius = ',num2str((fit_cyl.R+TipR)/INCH),' in.',...
                        ' Residual rms = ', num2str(fit_cyl.rms_err),' mm ',...
                        '[Exit flag = ',num2str(fit_cyl.exitflag),']']);
                    guess=guess+[0,0.05*randn(1,3),0,0.01*randn(1,3)];
                    guess=[guess(1), guess(2:4)/norm(guess(2:4)), guess(5), guess(6:8)/norm(guess(6:8))];
                    Niter=Niter+1;
                end
                if Niter>=10
                    disp('Solver did not converge');
                    return;
                end
                eval([FLEXURE,'.([web{1},loc{1}])=cylinder_fit(',FLEXURE,web{1},loc{1},'.data,guess);']);
                eval([FLEXURE,'.([web{1},loc{1}]).R=',FLEXURE,'.([web{1},loc{1}]).fit_param(1)+TipR;']);
            end
        end
    end
    %FITTED=true;
end

%% Calculate spacing
%clc;
for web_cell={'Long','Short'}
    web=web_cell{1};
    if isfield(eval(FLEXURE),[web,'Top'])
        eval([FLEXURE,'.(web).Plane=plane_fit(',FLEXURE,web,'Plane.data);']);
        eval(['top_surface=',FLEXURE,'.(web).Plane.center(3);']);

        eval(['TopCyl=',FLEXURE,'.',web,'Top;']);
        eval(['BottomCyl=',FLEXURE,'.',web,'Bottom;']);

        web_thickness=[];
        z=[0,.125,0.25]*INCH; %Measurement heights
        for k=1:length(z)
            Ct=TopCyl.center;
            meas_z=top_surface-z(k);
            at=TopCyl.axis;
            Rt=TopCyl.R;
            dt=(meas_z-Ct(3))/at(3);
            pt=Ct+dt*at;  %Top cylinder axis at z=z_meas

            Cb=BottomCyl.center;
            ab=BottomCyl.axis;
            Rb=BottomCyl.R;
            db=(meas_z-Cb(3))/ab(3);
            pb=Cb+db*ab;  %Bottom cylinder axis at z=z_meas

            web_thickness(k)=norm(pt-pb)-Rt-Rb;
            cyl_ang=asin(norm(cross(TopCyl.axis,BottomCyl.axis)));
        end
        eval([FLEXURE,'.(web).meas_points=z;']);
        eval([FLEXURE,'.(web).thickness=web_thickness;']);
        eval([FLEXURE,'.(web).max=max(web_thickness);']);
        eval([FLEXURE,'.(web).min=min(web_thickness);']);
        eval([FLEXURE,'.(web).nominal=mean(web_thickness);']);
        eval([FLEXURE,'.(web).angle=cyl_ang;']);
        disp(['Thickness of ',FLEXURE,' -- ',web]);
        disp(['Angle between cylinders = ',num2str(cyl_ang), ' rad, (',num2str(cyl_ang/pi*180),' deg)']);
        disp(['Minimum = ',num2str(min(web_thickness)/INCH),' in'])
        disp(['Maximum = ',num2str(max(web_thickness)/INCH),' in'])
        disp(['Nominal = ',num2str(web_thickness(2)/INCH),' in'])
    end
end

