%% Plot the flexure thickness of the web.
% Graham Allen
% 7/13/2009

%% Flexure web parameters

R = 0.25; %in
thick = 0.004; %in
thick_tol = .0005; %in

web_thick=@(x) thick+2*(R-sqrt(R^2-x.^2));

%% Make plot

x=-.02:.0001:.02;
figure(1);
plot(x,web_thick(x),[x(1);x(end)],thick+[thick_tol, -thick_tol;thick_tol, -thick_tol],'--r')
text(-1e-2,.0046,'Web thickness tolerance')
xlabel('Offset from center of the flexure (in)');
ylabel('Web thickness (in)');
ylim([3e-3,6e-3])

figure(2);
plot(x*1e3,(web_thick(x)-thick)*1e3, [x(1) x(end)]*1e3, 1e3*1e-4*[1 1],'--r')
xlabel('Offset from center of the flexure (10^{-3} in)');
ylabel('Error in measured thickness (10^{-3} in)');
xlim([-8 8]);
ylim([-0.05 .5]);
text(-3,1.2e-1,'Requirement')

%% Error measuring center of flexure
thick_err=@(x) 2*(R-sqrt(R^2-x.^2));
x=-.01:1e-5:.01;
figure(3);
plot(x,thick_err(x),[x(1),x(end)],1e-4*[1,1],'--r');
text(-.0045,1.2e-4,'Requirement')
xlabel('Offset between ref. sphere and indicator axis (in)');
ylabel('Web thickness measurement error(in)');


%% Zero set point error
% The zero set point is likely the most difficult error to avoid.
% A precision gauge block should probably be used to improve the accuracy
% of the zero point

R1=.125; % 0.25" ball-bearing
R2=.08;  % Standard Mitutoyo indicator tip

zero_err=@(x) (R1+R2)-(R1+R2)*cos(asin(x/(R1+R2)));

y=-1e-2:1e-4:1e-2;
figure(4)
plot(y,zero_err(y),[y(1),y(end)],1e-4*[1,1],'--r');
text(-5e-3,1.1e-4,'No correction required limit');
xlabel('Offset between locating sphere and indicator axis (in)')
ylabel('Error in zero set point (in)')
